//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.5

import wesual.Create 1.0
import wesual.Ui     1.0

import wesual.data.Core 1.0

UiDialog {
    id : importDialog

    readonly property MediaAssetFolder importFolder : {
        const author = Creator.context.activeAuthor;
        if (!author)
            return null;

        const workspace = author.workspace;
        if (!workspace)
            return null;

        if (workspace.mediaAccess === Workspace.FullMediaAccess) {
            return workspace.mediaImportFolder ||
                    Creator.context.loadedDocument("wesual.folder.Root");
        } else {
            return workspace.mediaImportFolder;
        }
    }

    function importFiles(files) {
        if (!importer.targetFolder) {
            importer.targetFolder = importDialog.importFolder;
        }

        importer.importFiles(files);
    }

    function fileExtensionsForType(type) {
        return importer.fileExtensionsForType(type);
    }

    property alias context      : importer.context
    property alias targetFolder : importer.targetFolder

    readonly property AssetImporter importer : AssetImporter {
        id : importer

        onRunningChanged : {
            if (running) {
                importDialog.show();
            }
        }
        onFinished : importDialog.accept(assets)
    }

    readonly property var supportedFileExtensions :
        importer.supportedFileExtensions

    label : qsTrId("6581bf6785172d86")

    contentDelegate : Item {
        implicitWidth  : 450
        implicitHeight : content.implicitHeight + 2 * content.anchors.margins

        Column {
            id : content

            anchors.fill    : parent
            anchors.margins : 14

            spacing : 8

            UiText {
                text : qsTrId("0184fac76921d6d9")
                    .arg(importer.filesDone).arg(importer.filesTotal)

                anchors {
                    left  : parent.left
                    right : parent.right
                }
            }

            UiProgressBar {
                progress : importer.progress
                animated : true

                anchors {
                    left  : parent.left
                    right : parent.right
                }
            }
        }
    }

    flags   : UiDialog.RejectOnCloseEvent | UiDialog.RejectOnEscape
    buttons : UiDialogButton {
        role : UiDialogButton.CancelRole
    }

    onRejected : importer.abort()
}
